/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportFilter<T extends DataContainer>
extends OptionHandlingObject
implements Comparable,
ShallowCopySupporter<AbstractReportFilter> {
    private static final long serialVersionUID = -7572598575382208115L;

    @Override
    protected void reset() {
        super.reset();
    }

    public void cleanUp() {
        this.reset();
    }

    public T filter(T data) {
        this.checkData(data);
        T result = this.processData(data);
        return result;
    }

    protected void checkData(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract T processData(T var1);

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractReportFilter shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractReportFilter shallowCopy(boolean expand) {
        return (AbstractReportFilter)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getFilters() {
        return ClassLister.getSingleton().getClassnames(AbstractReportFilter.class);
    }

    public static AbstractReportFilter forName(String classname, String[] options) {
        AbstractReportFilter result;
        try {
            result = (AbstractReportFilter)OptionUtils.forName(AbstractReportFilter.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractReportFilter forCommandLine(String cmdline) {
        return (AbstractReportFilter)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

