/*
 * Decompiled with CFR 0.152.
 */
package adams.data.utils;

import adams.core.Utils;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.enums.ValueType;

public class SavitzkyGolay {
    public static double[] determineCoefficients(int numLeft, int numRight, int polyOrder, int derOrder) {
        return SavitzkyGolay.determineCoefficients(numLeft, numRight, polyOrder, derOrder, false);
    }

    public static double[] determineCoefficients(int numLeft, int numRight, int polyOrder, int derOrder, boolean debug) {
        float sum;
        int j;
        double[] result = new double[numLeft + numRight + 1];
        if (result.length == 1) {
            result[0] = 1.0;
            return result;
        }
        Matrix A = MatrixFactory.dense((ValueType)ValueType.DOUBLE, (long[])new long[]{polyOrder + 1, polyOrder + 1});
        int i = 0;
        while ((long)i < A.getRowCount()) {
            j = 0;
            while ((long)j < A.getColumnCount()) {
                sum = 0.0f;
                for (int k = -numLeft; k <= numRight; ++k) {
                    sum = (float)((double)sum + Math.pow(k, i + j));
                }
                A.setAsDouble((double)sum, new long[]{i, j});
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println("A:\n" + A);
        }
        Matrix b = MatrixFactory.dense((ValueType)ValueType.DOUBLE, (long[])new long[]{polyOrder + 1, 1L});
        b.setAsDouble(1.0, new long[]{derOrder, 0L});
        if (debug) {
            System.out.println("b:\n" + b);
        }
        LU.LUMatrix lu = new LU.LUMatrix(A);
        Matrix solution = lu.solve(b);
        if (debug) {
            System.out.println("LU decomp. - solution:\n" + solution);
        }
        for (i = -numLeft; i <= numRight; ++i) {
            sum = 0.0f;
            for (j = 0; j <= polyOrder; ++j) {
                sum = (float)((double)sum + solution.getAsDouble(new long[]{j, 0L}) * Math.pow(i, j));
            }
            result[i + numLeft] = sum;
        }
        if (debug) {
            System.out.println("Coefficients:\n" + Utils.arrayToString(result));
        }
        return result;
    }
}

