/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.BasePassword;
import adams.core.option.OptionHandlingObject;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionEstablisher;
import adams.db.DatabaseConnectionHandler;
import adams.db.DatabaseConnectionParameterHandler;

public abstract class OptionHandlingDatabaseObject
extends OptionHandlingObject
implements DatabaseConnectionHandler,
DatabaseConnectionEstablisher,
DatabaseConnectionParameterHandler {
    private static final long serialVersionUID = -8800746361445333658L;
    protected transient AbstractDatabaseConnection m_dbc;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected boolean m_NoDatabaseConnect;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", DatabaseConnection.getSingleton().getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", DatabaseConnection.getSingleton().getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", DatabaseConnection.getSingleton().getDefaultPassword(), false);
        this.m_OptionManager.add("no-connect", "noDatabaseConnect", false);
    }

    protected void initialize() {
        super.initialize();
        this.m_dbc = null;
    }

    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_dbc = value;
        if (value != null) {
            this.m_URL = value.getURL();
            this.m_User = value.getUser();
            this.m_Password = value.getPassword();
        } else {
            this.m_URL = "";
            this.m_User = "";
            this.m_Password = new BasePassword("");
        }
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_dbc;
    }

    public void setURL(String value) {
        this.m_URL = value;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The database URL.";
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The database user.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the database user.";
    }

    public void setNoDatabaseConnect(boolean value) {
        this.m_NoDatabaseConnect = value;
    }

    public boolean getNoDatabaseConnect() {
        return this.m_NoDatabaseConnect;
    }

    public String noDatabaseConnectTipText() {
        return "If set to true, no database connection is established.";
    }

    public void establishDatabaseConnection() {
        if (!this.m_NoDatabaseConnect) {
            if (this.isDebugOn()) {
                this.debug("Connecting to database");
            }
            this.m_dbc = DatabaseConnection.getSingleton(this.m_URL, this.m_User, this.m_Password);
        } else if (this.isDebugOn()) {
            this.debug("Skipping database connection");
        }
    }
}

