/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Pausable;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.Compatibility;
import adams.flow.core.ControlActor;
import adams.flow.core.InputConsumer;
import java.util.HashSet;

public abstract class AbstractControlActor
extends AbstractActor
implements ControlActor,
ActorHandler,
Pausable {
    private static final long serialVersionUID = -7471817724012995179L;
    protected Compatibility m_Compatibility;

    protected void initialize() {
        super.initialize();
        this.m_Compatibility = new Compatibility();
    }

    public void setHeadless(boolean value) {
        super.setHeadless(value);
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setHeadless(value);
        }
    }

    public void setParent(AbstractActor value) {
        super.setParent(value);
        if (value != null) {
            this.updateParent();
        }
    }

    public abstract ActorHandlerInfo getActorHandlerInfo();

    public abstract int size();

    public int active() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            ++result;
        }
        return result;
    }

    public AbstractActor firstActive() {
        AbstractActor result = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    public AbstractActor lastActive() {
        AbstractActor result = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i).getSkip()) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    public AbstractActor firstInputConsumer() {
        AbstractActor result = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip() || !(this.get(i) instanceof InputConsumer)) continue;
            result = this.get(i);
            break;
        }
        return result;
    }

    public abstract AbstractActor get(int var1);

    public abstract void set(int var1, AbstractActor var2);

    public abstract int indexOf(String var1);

    protected void updateParent() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setParent(null);
            this.get(i).setParent(this);
        }
    }

    protected boolean canInspectOptions(Class cls) {
        if (cls == AbstractActor[].class) {
            return false;
        }
        if (cls == AbstractActor.class) {
            return false;
        }
        return super.canInspectOptions(cls);
    }

    protected String setUpSubActors() {
        String result = null;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.size(); ++i) {
            ActorUtils.uniqueName(this.get(i), names);
            names.add(this.get(i).getName());
            if (this.get(i).getSkip() || (result = this.get(i).setUp()) == null) continue;
            result = this.get(i).getFullName() + ": " + result;
            break;
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.setUpSubActors();
        }
        if (result == null) {
            String msg = this.check();
            if (this.isDebugOn()) {
                this.debug("check: " + (msg == null ? "OK" : msg));
            }
            if (msg != null) {
                result = "Check failed: " + msg;
            }
        }
        return result;
    }

    public String check() {
        return null;
    }

    public void wrapUp() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            this.get(i).wrapUp();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getSkip()) continue;
            this.get(i).cleanUp();
        }
        super.cleanUp();
    }

    public void destroy() {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).destroy();
        }
        super.destroy();
    }

    public void pauseExecution() {
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof Pausable)) continue;
            ((Pausable)((Object)this.get(i))).pauseExecution();
        }
    }

    public boolean isPaused() {
        return false;
    }

    public void resumeExecution() {
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.get(i) instanceof Pausable)) continue;
            ((Pausable)((Object)this.get(i))).resumeExecution();
        }
    }
}

