/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.core.ControlActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Injector
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = 5477999576142658922L;
    public static final String BACKUP_COUNTER = "counter";
    public static final String BACKUP_QUEUE = "queue";
    protected String m_Injection;
    protected Location m_Location;
    protected int m_EveryNth;
    protected Vector<String> m_Queue;
    protected int m_Counter;

    @Override
    public String globalInfo() {
        return "Injects a string token into the token sequence.\nThe string can be inject before or after the current token. One can also control how often the string gets injected, i.e., every n-th token.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("injection", "injection", "inject_me");
        this.m_OptionManager.add("location", "location", (Object)Location.AFTER);
        this.m_OptionManager.add("nth", "everyNth", 1, 1, null);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("injection");
        if (variable != null) {
            return variable;
        }
        if (this.m_Injection.length() > 0) {
            return this.m_Injection;
        }
        return null;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Queue = new Vector();
    }

    public void setInjection(String value) {
        this.m_Injection = value;
        this.reset();
    }

    public String getInjection() {
        return this.m_Injection;
    }

    public String injectionTipText() {
        return "The string to inject into the sequence.";
    }

    public void setLocation(Location value) {
        this.m_Location = value;
        this.reset();
    }

    public Location getLocation() {
        return this.m_Location;
    }

    public String locationTipText() {
        return "The location where to inject the string.";
    }

    public void setEveryNth(int value) {
        if (value >= 1) {
            this.m_EveryNth = value;
            this.reset();
        } else {
            this.getSystemErr().println("Value for every nth has to be at least 1, provided: " + value);
        }
    }

    public int getEveryNth() {
        return this.m_EveryNth;
    }

    public String everyNthTipText() {
        return "The number of tokens after which the injection takes place.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_COUNTER);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_COUNTER, this.m_Counter);
        result.put(BACKUP_QUEUE, this.m_Queue);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_COUNTER)) {
            this.m_Counter = (Integer)state.get(BACKUP_COUNTER);
            state.remove(BACKUP_COUNTER);
        }
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (Vector)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Counter = 0;
        this.m_Queue.clear();
    }

    @Override
    protected String doExecute() {
        String result = null;
        ++this.m_Counter;
        this.m_Queue.add((String)this.m_InputToken.getPayload());
        if (this.m_Counter % this.m_EveryNth == 0) {
            if (this.m_Location == Location.BEFORE) {
                this.m_Queue.insertElementAt(this.m_Injection, 0);
            } else if (this.m_Location == Location.AFTER) {
                this.m_Queue.addElement(this.m_Injection);
            } else {
                result = "Unhandled location: " + (Object)((Object)this.m_Location);
            }
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        this.m_OutputToken = null;
        this.m_InputToken = null;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_Queue.clear();
        super.wrapUp();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        BEFORE,
        AFTER;

    }
}

