/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.core.AbstractActor;
import adams.flow.core.ControlActor;
import adams.flow.core.EventHelper;
import adams.flow.core.TriggerableEventReference;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class TriggerEvent
extends AbstractTransformer
implements ControlActor {
    private static final long serialVersionUID = -6090673233883296452L;
    protected TriggerableEventReference m_Event;
    protected AbstractActor m_EventActor;
    protected EventHelper m_Helper;

    public String globalInfo() {
        return "Triggers the specified event.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("event", "event", new TriggerableEventReference());
    }

    protected void reset() {
        super.reset();
        this.m_EventActor = null;
        this.m_Helper = new EventHelper();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("event");
        if (variable != null) {
            return variable;
        }
        return this.m_Event.getValue();
    }

    public void setEvent(TriggerableEventReference value) {
        this.m_Event = value;
        this.reset();
    }

    public TriggerableEventReference getEvent() {
        return this.m_Event;
    }

    public String eventTipText() {
        return "The name of the event to trigger.";
    }

    protected AbstractActor findEventActor() {
        return this.m_Helper.findEventRecursive(this, this.getEvent());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_EventActor = this.findEventActor();
            if (this.m_EventActor == null) {
                result = "Couldn't find event actor '" + this.getEvent() + "'!";
            }
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    protected String doExecute() {
        this.m_OutputToken = this.m_InputToken;
        String result = this.m_EventActor.execute();
        return result;
    }
}

