/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import java.util.HashSet;

public abstract class AbstractGlobalActor
extends AbstractActor {
    private static final long serialVersionUID = -6652513967046303107L;
    protected GlobalActorReference m_GlobalName;
    protected AbstractActor m_GlobalActor;
    protected GlobalActorHelper m_Helper;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("global", "globalName", new GlobalActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new GlobalActorHelper();
    }

    public void setGlobalName(GlobalActorReference value) {
        this.m_GlobalName = value;
        this.reset();
    }

    public GlobalActorReference getGlobalName() {
        return this.m_GlobalName;
    }

    public String globalNameTipText() {
        return "The name of the global actor to use.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("globalName");
        if (variable != null) {
            return variable;
        }
        if (this.m_GlobalName != null && this.m_GlobalName.toString().length() > 0) {
            return this.m_GlobalName.toString();
        }
        return null;
    }

    protected AbstractActor findGlobalActor() {
        return this.m_Helper.findGlobalActorRecursive(this, this.getGlobalName());
    }

    public boolean hasGlobalActor() {
        return this.m_GlobalActor != null;
    }

    public AbstractActor getGlobalActor() {
        return this.m_GlobalActor;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_GlobalActor = this.findGlobalActor();
            if (this.m_GlobalActor == null) {
                result = "Couldn't find global actor '" + this.getGlobalName() + "'!";
            } else {
                HashSet<String> variables = this.findVariables(this.m_GlobalActor);
                this.m_DetectedVariables.addAll(variables);
                if (this.m_DetectedVariables.size() > 0) {
                    this.getVariables().addVariableChangeListener(this);
                }
            }
        }
        return result;
    }

    protected abstract String executeGlobalActor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        if (!this.m_GlobalActor.getSkip() && !this.m_GlobalActor.isStopped()) {
            AbstractActor abstractActor = this.m_GlobalActor;
            synchronized (abstractActor) {
                if (this.isDebugOn()) {
                    this.debug("Executing global actor - start: " + this.m_GlobalActor);
                }
                result = this.executeGlobalActor();
                if (this.isDebugOn()) {
                    this.debug("Executing global actor - end: " + result);
                }
            }
        }
        return result;
    }

    public boolean isFinished() {
        if (this.m_GlobalActor == null) {
            return true;
        }
        return this.m_GlobalActor.isFinished();
    }

    public void stopExecution() {
        try {
            if (this.m_GlobalActor != null) {
                this.m_GlobalActor.notifyAll();
                this.m_GlobalActor.stopExecution();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stopExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        if (this.m_GlobalActor != null) {
            AbstractActor abstractActor = this.m_GlobalActor;
            synchronized (abstractActor) {
                this.m_GlobalActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    public void cleanUp() {
        super.cleanUp();
        if (this.m_GlobalActor != null) {
            this.m_GlobalActor.cleanUp();
            this.m_GlobalActor = null;
        }
    }
}

