/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.setup;

import adams.core.CloneHandler;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.option.OptionUtils;
import adams.event.FlowSetupStateEvent;
import adams.event.FlowSetupStateListener;
import adams.flow.setup.FlowSetup;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowSetupManager
extends Vector<FlowSetup>
implements FlowSetupStateListener,
CloneHandler<FlowSetupManager> {
    private static final long serialVersionUID = -571220451906124470L;
    public static final String COUNT = "count";
    public static final String SETUP_PREFIX = "setup.";
    public static final String PLACEHOLDER_PREFIX = "placeholder.";
    protected boolean m_Modified;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected StatusMessageHandler m_StatusMessageHandler;

    public FlowSetupManager() {
        this.m_Modified = false;
        this.m_ChangeListeners = new HashSet();
        this.m_StatusMessageHandler = null;
    }

    public FlowSetupManager(Collection<FlowSetup> collection) {
        super(collection);
        Iterator<FlowSetup> iter = collection.iterator();
        while (iter.hasNext()) {
            iter.next().addFlowSetupStateChangeListener(this);
        }
        this.m_Modified = false;
    }

    public void setStatusMessageHandler(StatusMessageHandler value) {
        this.m_StatusMessageHandler = value;
    }

    public StatusMessageHandler getStatusMessageHandler() {
        return this.m_StatusMessageHandler;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    protected void modified() {
        this.modified(true);
    }

    protected void modified(boolean modified) {
        this.m_Modified = modified;
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    @Override
    public synchronized boolean add(FlowSetup e) {
        boolean result = super.add(e);
        e.setOwner(this);
        e.addFlowSetupStateChangeListener(this);
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends FlowSetup> c) {
        boolean result = super.addAll(c);
        for (FlowSetup flowSetup : c) {
            flowSetup.setOwner(this);
            flowSetup.addFlowSetupStateChangeListener(this);
        }
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public synchronized void addElement(FlowSetup obj) {
        boolean modified = !this.contains(obj);
        this.modified();
        super.addElement(obj);
        obj.setOwner(this);
        obj.addFlowSetupStateChangeListener(this);
        if (!modified) {
            this.modified();
        }
    }

    @Override
    public void add(int index, FlowSetup element) {
        super.add(index, element);
        element.setOwner(this);
        element.addFlowSetupStateChangeListener(this);
        this.modified();
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends FlowSetup> c) {
        boolean result = super.addAll(index, c);
        for (FlowSetup flowSetup : c) {
            flowSetup.setOwner(this);
            flowSetup.addFlowSetupStateChangeListener(this);
        }
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public void clear() {
        boolean modified = this.size() > 0;
        for (int i = 0; i < this.size(); ++i) {
            ((FlowSetup)this.get(i)).setOwner(null);
            ((FlowSetup)this.get(i)).removeFlowSetupStateChangeListener(this);
        }
        super.clear();
        if (modified) {
            this.modified();
        }
    }

    @Override
    public synchronized FlowSetupManager getClone() {
        FlowSetupManager result = new FlowSetupManager();
        for (int i = 0; i < this.size(); ++i) {
            result.add(((FlowSetup)this.get(i)).shallowCopy());
        }
        result.setModified(this.m_Modified);
        return result;
    }

    @Override
    public synchronized void insertElementAt(FlowSetup obj, int index) {
        super.insertElementAt(obj, index);
        obj.setOwner(this);
        obj.addFlowSetupStateChangeListener(this);
        this.modified();
    }

    @Override
    public synchronized FlowSetup remove(int index) {
        ((FlowSetup)this.get(index)).setOwner(null);
        ((FlowSetup)this.get(index)).removeFlowSetupStateChangeListener(this);
        FlowSetup result = (FlowSetup)super.remove(index);
        this.modified();
        return result;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean result = super.removeAll(c);
        for (FlowSetup setup : c) {
            setup.setOwner(null);
            setup.removeFlowSetupStateChangeListener(this);
        }
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        ((FlowSetup)o).setOwner(null);
        ((FlowSetup)o).removeFlowSetupStateChangeListener(this);
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public synchronized void removeAllElements() {
        boolean modified = this.size() > 0;
        for (int i = 0; i < this.size(); ++i) {
            ((FlowSetup)this.get(i)).setOwner(null);
            ((FlowSetup)this.get(i)).removeFlowSetupStateChangeListener(this);
        }
        super.removeAllElements();
        if (modified) {
            this.modified();
        }
    }

    @Override
    public synchronized boolean removeElement(Object obj) {
        boolean result = super.removeElement(obj);
        ((FlowSetup)obj).setOwner(null);
        ((FlowSetup)obj).removeFlowSetupStateChangeListener(this);
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public synchronized void removeElementAt(int index) {
        ((FlowSetup)this.get(index)).setOwner(null);
        ((FlowSetup)this.get(index)).removeFlowSetupStateChangeListener(this);
        super.removeElementAt(index);
        this.modified();
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            ((FlowSetup)this.get(i)).setOwner(null);
            ((FlowSetup)this.get(i)).removeFlowSetupStateChangeListener(this);
        }
        super.removeRange(fromIndex, toIndex);
        this.modified();
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        for (int i = 0; i < this.size(); ++i) {
            FlowSetup setup = (FlowSetup)this.get(i);
            if (c.contains(setup)) continue;
            setup.setOwner(null);
            setup.removeFlowSetupStateChangeListener(this);
        }
        boolean result = super.retainAll(c);
        if (result) {
            this.modified();
        }
        return result;
    }

    @Override
    public synchronized FlowSetup set(int index, FlowSetup element) {
        ((FlowSetup)this.get(index)).setOwner(null);
        ((FlowSetup)this.get(index)).removeFlowSetupStateChangeListener(this);
        element.setOwner(this);
        element.addFlowSetupStateChangeListener(this);
        FlowSetup result = super.set(index, element);
        this.modified();
        return result;
    }

    @Override
    public synchronized void setElementAt(FlowSetup obj, int index) {
        ((FlowSetup)this.get(index)).setOwner(null);
        ((FlowSetup)this.get(index)).removeFlowSetupStateChangeListener(this);
        obj.setOwner(this);
        obj.addFlowSetupStateChangeListener(this);
        super.setElementAt(obj, index);
        this.modified();
    }

    @Override
    public synchronized void setSize(int newSize) {
        boolean modified = this.size() != newSize;
        for (int i = this.size(); i < newSize; ++i) {
            ((FlowSetup)this.get(i)).setOwner(null);
            ((FlowSetup)this.get(i)).removeFlowSetupStateChangeListener(this);
        }
        super.setSize(newSize);
        if (modified) {
            this.modified();
        }
    }

    public boolean write(String filename) {
        Properties props = new Properties();
        props.setInteger(COUNT, this.size());
        for (int i = 0; i < this.size(); ++i) {
            props.setString(SETUP_PREFIX + i, ((FlowSetup)this.get(i)).toCommandLine());
        }
        boolean result = props.save(filename);
        if (result) {
            this.modified(false);
        }
        return result;
    }

    public boolean read(String filename) {
        boolean result = false;
        this.clear();
        Properties props = new Properties();
        props.load(filename);
        if (props.hasKey(COUNT)) {
            int count = props.getInteger(COUNT);
            Vector<FlowSetup> setups = new Vector<FlowSetup>();
            for (int i = 0; i < count; ++i) {
                try {
                    FlowSetup setup = (FlowSetup)OptionUtils.forAnyCommandLine(FlowSetup.class, props.getString(SETUP_PREFIX + i));
                    setups.add(setup);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error loading setup #" + i + " (0-based index) from '" + filename + "':");
                    e.printStackTrace();
                    setups = null;
                    break;
                }
            }
            if (setups != null) {
                result = true;
                this.clear();
                this.addAll((Collection<? extends FlowSetup>)setups);
                this.m_Modified = false;
            }
        }
        return result;
    }

    public synchronized int indexOf(String name) {
        int result = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!((FlowSetup)this.get(i)).getName().equals(name)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public void flowSetupStateChanged(FlowSetupStateEvent e) {
        this.notifyChangeListeners(new ChangeEvent(this));
        FlowSetup setup = e.getFlowSetup();
        int index = -1;
        if (e.getType() == FlowSetupStateEvent.Type.ERROR && setup.hasLastError() && setup.hasOnError()) {
            index = this.indexOf(setup.getOnError());
        } else if (e.getType() == FlowSetupStateEvent.Type.FINISHED && setup.hasOnFinish()) {
            index = this.indexOf(setup.getOnFinish());
        }
        if (index > -1) {
            setup.cleanUp();
            FlowSetup setupNext = (FlowSetup)this.get(index);
            setupNext.execute();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners(ChangeEvent e) {
        Iterator<ChangeListener> iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().stateChanged(e);
        }
    }
}

