/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.NamedCounter;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.sequenceplotter.AbstractSequencePostProcessor;
import adams.flow.sink.sequenceplotter.MarkerPaintlet;
import adams.flow.sink.sequenceplotter.NoMarkers;
import adams.flow.sink.sequenceplotter.PassThrough;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceStickPaintlet;

public class SequencePlotter
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = 3238389451500168650L;
    protected XYSequencePointComparator.Comparison m_ComparisonType;
    protected AbstractXYSequencePaintlet m_Paintlet;
    protected MarkerPaintlet m_MarkerPaintlet;
    protected AbstractColorProvider m_ColorProvider;
    protected String m_Title;
    protected AxisPanelOptions m_AxisX;
    protected AxisPanelOptions m_AxisY;
    protected int m_UpdateInterval;
    protected AbstractSequencePostProcessor m_PostProcessor;
    protected int m_NumTokensAccepted;
    protected NamedCounter m_Counter;

    public String globalInfo() {
        return "Actor that plots sequences over time.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("comparison", "comparisonType", (Object)XYSequencePointComparator.Comparison.X);
        this.m_OptionManager.add("paintlet", "paintlet", new XYSequenceStickPaintlet());
        this.m_OptionManager.add("marker-paintlet", "markerPaintlet", new NoMarkers());
        this.m_OptionManager.add("color-provider", "colorProvider", new DefaultColorProvider());
        this.m_OptionManager.add("title", "title", "X-Y Sequences");
        this.m_OptionManager.add("axis-x", "axisX", this.getDefaultAxisX());
        this.m_OptionManager.add("axis-y", "axisY", this.getDefaultAxisY());
        this.m_OptionManager.add("update-interval", "updateInterval", 1, 1, null);
        this.m_OptionManager.add("post-processor", "postProcessor", new PassThrough());
    }

    protected void initialize() {
        super.initialize();
        this.m_Counter = new NamedCounter();
    }

    protected void reset() {
        super.reset();
        this.m_NumTokensAccepted = 0;
        this.m_Counter.clear();
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 350;
    }

    public void setComparisonType(XYSequencePointComparator.Comparison value) {
        this.m_ComparisonType = value;
        this.reset();
    }

    public XYSequencePointComparator.Comparison getComparisonType() {
        return this.m_ComparisonType;
    }

    public String comparisonTypeTipText() {
        return "The type of comparison to use for the data points of the sequence.";
    }

    public void setPaintlet(AbstractXYSequencePaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public AbstractXYSequencePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for painting the data.";
    }

    public void setMarkerPaintlet(MarkerPaintlet value) {
        this.m_MarkerPaintlet = value;
        this.reset();
    }

    public MarkerPaintlet getMarkerPaintlet() {
        return this.m_MarkerPaintlet;
    }

    public String markerPaintletTipText() {
        return "The marker paintlet to use for painting marker overlays.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for generating the colors for the various plots.";
    }

    protected AxisPanelOptions getDefaultAxisX() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("x");
        result.setCustomFormat("0.000");
        result.setShowGridLines(true);
        result.setShowOnlyMajorGridLines(false);
        result.setLengthTicks(4);
        result.setNumTicks(20);
        result.setWidth(40);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        return result;
    }

    protected AxisPanelOptions getDefaultAxisY() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("y");
        result.setCustomFormat("0.0");
        result.setShowGridLines(true);
        result.setShowOnlyMajorGridLines(false);
        result.setLengthTicks(4);
        result.setNumTicks(10);
        result.setWidth(40);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        return result;
    }

    public void setAxisX(AxisPanelOptions value) {
        this.m_AxisX = value;
        this.reset();
    }

    public AxisPanelOptions getAxisX() {
        return this.m_AxisX;
    }

    public String axisXTipText() {
        return "The setup for the X axis.";
    }

    public void setAxisY(AxisPanelOptions value) {
        this.m_AxisY = value;
        this.reset();
    }

    public AxisPanelOptions getAxisY() {
        return this.m_AxisY;
    }

    public String axisYTipText() {
        return "The setup for the Y axis.";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title for the border around the plot.";
    }

    public void setUpdateInterval(int value) {
        if (value >= 1) {
            this.m_UpdateInterval = value;
            this.reset();
        } else {
            this.getSystemErr().println("Update interval must be >= 1, provided: " + value);
        }
    }

    public int getUpdateInterval() {
        return this.m_UpdateInterval;
    }

    public String updateIntervalTipText() {
        return "Specifies the number of tokens after which the display is being updated.";
    }

    public void setPostProcessor(AbstractSequencePostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractSequencePostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to use on the sequences after a token has been added.";
    }

    public void clearPanel() {
        ((XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager()).clear();
        ((SequencePlotterPanel)this.m_Panel).getMarkerContainerManager().clear();
    }

    protected BasePanel newPanel() {
        SequencePlotterPanel result = new SequencePlotterPanel(this.getTitle());
        result.setPaintlet(this.getPaintlet());
        result.setMarkerPaintlet(this.getMarkerPaintlet());
        this.m_AxisX.configure(result.getPlot(), Axis.BOTTOM);
        this.m_AxisY.configure(result.getPlot(), Axis.LEFT);
        result.setColorProvider(this.m_ColorProvider);
        return result;
    }

    protected String createTitle() {
        return "Sequence plot - " + this.getFullName();
    }

    public Class[] accepts() {
        return new Class[]{SequencePlotterContainer.class};
    }

    protected void display(Token token) {
        XYSequence seq;
        ++this.m_NumTokensAccepted;
        SequencePlotterContainer plotCont = (SequencePlotterContainer)token.getPayload();
        String plotName = (String)plotCont.getValue("PlotName");
        Double x = (Double)plotCont.getValue("X");
        Double y = (Double)plotCont.getValue("Y");
        boolean isMarker = (Boolean)plotCont.getValue("IsMarker");
        XYSequenceContainerManager manager = isMarker ? ((SequencePlotterPanel)this.m_Panel).getMarkerContainerManager() : (XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager();
        manager.startUpdate();
        if (manager.indexOf(plotName) == -1) {
            seq = new XYSequence();
            seq.setComparison(this.m_ComparisonType);
            seq.setID(plotName);
            XYSequenceContainer cont = manager.newContainer(seq);
            manager.add(cont);
        } else {
            XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(plotName));
            seq = cont.getData();
        }
        if (x == null) {
            x = new Double(this.m_Counter.next(plotName));
        }
        XYSequencePoint<Double, Double> point = new XYSequencePoint<Double, Double>("" + seq.size(), x, y);
        seq.add(point);
        if (!isMarker) {
            this.m_PostProcessor.postProcess(manager, plotName);
        }
        manager.finishUpdate(this.m_NumTokensAccepted % this.m_UpdateInterval == 0);
    }

    public void wrapUp() {
        if (this.m_Panel != null && this.m_UpdateInterval > 1) {
            ((SequencePlotterPanel)this.m_Panel).getMarkerContainerManager().finishUpdate();
            ((XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager()).finishUpdate();
        }
        super.wrapUp();
    }
}

