/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.standalone.AbstractStandalone;

public class InitStorageCache
extends AbstractStandalone {
    private static final long serialVersionUID = 304023894924959060L;
    protected String m_Cache;
    protected int m_Size;

    public String globalInfo() {
        return "Adds a LRU cache in the responsible storage handler (usually the Flow actor).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("size", "size", 50, 1, null);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("cache");
        String result = variable != null ? variable : this.m_Cache;
        result = result + "/";
        variable = this.getOptionManager().getVariableForProperty("size");
        result = variable != null ? result + variable : result + this.m_Size;
        return result;
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the LRU cache to initialize.";
    }

    public void setSize(int value) {
        if (value >= 1) {
            this.m_Size = value;
            this.reset();
        } else {
            this.getSystemErr().println("Size must be at least 1, provided: " + value);
        }
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of the LRU cache.";
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Cache.length() == 0) {
            result = "No cache name provided!";
        }
        return result;
    }

    protected String doExecute() {
        this.getStorageHandler().getStorage().addCache(this.m_Cache, this.m_Size);
        return null;
    }
}

