/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.AppendName;
import adams.flow.transformer.DirName;
import java.io.File;

public class BaseName
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = 4670761846363281951L;

    public String globalInfo() {
        return "Extracts the name of the file/directory passing through, i.e., any preceding directory gets stripped.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{AppendName.class, DirName.class};
    }

    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class, String[].class};
    }

    protected String doExecute() {
        int i;
        String[] strings;
        File[] files;
        String result = null;
        boolean array = false;
        if (this.m_InputToken.getPayload() instanceof File) {
            files = new File[]{new PlaceholderFile((File)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
            array = true;
        } else if (this.m_InputToken.getPayload() instanceof String) {
            files = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            strings = (String[])this.m_InputToken.getPayload();
            files = new File[strings.length];
            for (i = 0; i < strings.length; ++i) {
                files[i] = new PlaceholderFile(strings[i]);
            }
            array = true;
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        strings = new String[files.length];
        for (i = 0; i < files.length; ++i) {
            strings[i] = files[i].getName();
        }
        this.m_OutputToken = array ? new Token(strings) : new Token(strings[0]);
        return result;
    }
}

