/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Utils;
import adams.core.base.BaseText;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.dialog.AbstractApprovalDialog;
import adams.gui.dialog.TextPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTextChooserPanel
extends AbstractChooserPanel<BaseText> {
    private static final long serialVersionUID = -8755020252465094120L;
    protected String m_DialogTitle;
    protected Dimension m_DialogSize;

    public BaseTextChooserPanel() {
        this(new BaseText(""));
    }

    public BaseTextChooserPanel(BaseText text) {
        this.setCurrent(text);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DialogTitle = "Enter text";
        this.m_DialogSize = new Dimension(400, 300);
    }

    public void setDialogTitle(String value) {
        this.m_DialogTitle = value;
    }

    public String getDialogTitle() {
        return this.m_DialogTitle;
    }

    public void setDialogSize(Dimension value) {
        this.m_DialogSize = value;
    }

    public Dimension getDialogSize() {
        return this.m_DialogSize;
    }

    @Override
    protected BaseText doChoose() {
        AbstractApprovalDialog dialog = this.getParentDialog() != null ? AbstractApprovalDialog.getDialog(this.getParentDialog()) : AbstractApprovalDialog.getDialog(this.getParentFrame());
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle(this.m_DialogTitle);
        TextPanel textPanel = new TextPanel();
        textPanel.setContent(((BaseText)this.getCurrent()).getValue());
        dialog.getContentPane().add((Component)textPanel, "Center");
        dialog.setSize(this.m_DialogSize);
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            return new BaseText(textPanel.getContent());
        }
        return null;
    }

    @Override
    protected String toString(BaseText value) {
        return Utils.backQuoteChars(value.getValue());
    }

    @Override
    protected BaseText fromString(String value) {
        return new BaseText(Utils.unbackQuoteChars(value));
    }
}

