/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.base.BaseDateTime;
import adams.core.base.BaseObject;
import adams.core.base.BaseTime;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freixas.jcalendar.JCalendar;

public class BaseDateTimeEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler {
    protected JCalendar m_Calendar;
    protected JComboBox m_ComboBoxPlaceholders;
    protected JTextField m_TextCustom;
    protected JButton m_ButtonNow;
    protected JButton m_ButtonOK;
    protected BaseDateTime m_DateTime;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseDateTime)object).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseDateTime(str);
    }

    protected void initialize() {
        super.initialize();
        this.m_DateTime = new BaseDateTime();
    }

    public String toCustomStringRepresentation(Object obj) {
        return BaseDateTimeEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return BaseDateTimeEditor.valueOf(null, str);
    }

    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + BaseDateTimeEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : BaseDateTimeEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelValues = new JPanel(new BorderLayout());
        panelAll.add((Component)panelValues, "Center");
        JPanel panelCustom = new JPanel(new BorderLayout());
        panelValues.add((Component)panelCustom, "South");
        this.m_Calendar = new JCalendar(Calendar.getInstance(), Locale.getDefault(), 3, false, "yyyy-MM-dd HH:mm:ss");
        panelValues.add((Component)this.m_Calendar, "Center");
        this.m_ComboBoxPlaceholders = new JComboBox<String>(new String[]{"Custom", "Selected", "-INF", "NOW", "+INF"});
        this.m_ComboBoxPlaceholders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = BaseDateTimeEditor.this.m_ComboBoxPlaceholders.getSelectedIndex();
                if (index > 1) {
                    BaseDateTime date = new BaseDateTime((String)BaseDateTimeEditor.this.m_ComboBoxPlaceholders.getSelectedItem());
                    BaseDateTimeEditor.this.m_Calendar.setDate(date.dateValue());
                }
                BaseDateTimeEditor.this.m_TextCustom.setEnabled(index == 0);
                BaseDateTimeEditor.this.m_ButtonNow.setEnabled(index == 1);
                BaseDateTimeEditor.this.m_Calendar.setEnabled(index != 1);
                BaseDateTimeEditor.this.m_Calendar.setEnabled(index == 1);
            }
        });
        this.m_ButtonNow = new JButton("Now");
        this.m_ButtonNow.setMnemonic('N');
        this.m_ButtonNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseDateTimeEditor.this.m_Calendar.setDate(new BaseTime("NOW").dateValue());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add(new JLabel("Type"));
        panel.add(this.m_ComboBoxPlaceholders);
        panel.add(this.m_ButtonNow);
        panelCustom.add((Component)panel, "North");
        this.m_TextCustom = new JTextField(22);
        this.m_TextCustom.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                BaseDateTimeEditor.this.updateButtons();
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add(new JLabel("Custom date/time"));
        panel.add(this.m_TextCustom);
        panelCustom.add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = BaseDateTimeEditor.this.m_ComboBoxPlaceholders.getSelectedIndex();
                if (index == 0) {
                    BaseDateTimeEditor.this.setValue(new BaseDateTime(BaseDateTimeEditor.this.m_TextCustom.getText()));
                } else if (index == 1) {
                    BaseDateTimeEditor.this.setValue(new BaseDateTime(BaseDateTimeEditor.this.m_Calendar.getDate()));
                } else {
                    BaseDateTimeEditor.this.setValue(new BaseDateTime((String)BaseDateTimeEditor.this.m_ComboBoxPlaceholders.getSelectedItem()));
                }
                BaseDateTimeEditor.this.closeDialog();
            }
        });
        panelButtons.add(this.m_ButtonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseDateTimeEditor.this.closeDialog();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected void updateButtons() {
        int index = this.m_ComboBoxPlaceholders.getSelectedIndex();
        if (index == 0) {
            this.m_ButtonOK.setEnabled(this.m_DateTime.isValid(this.m_TextCustom.getText()));
        } else {
            this.m_ButtonOK.setEnabled(true);
        }
    }

    protected void initForDisplay() {
        this.m_TextCustom.setText(((BaseDateTime)this.getValue()).getValue());
        this.m_TextCustom.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_Calendar.setDate(((BaseDateTime)this.getValue()).dateValue());
        this.m_ComboBoxPlaceholders.setSelectedIndex(this.m_ComboBoxPlaceholders.getSelectedIndex());
        this.updateButtons();
    }
}

