/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.ConsoleObject;
import adams.core.StatusMessageHandler;
import adams.core.Utils;
import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.gui.core.BasePanel;
import adams.gui.core.Undo;
import adams.gui.core.UndoHandler;
import adams.gui.scripting.AbstractDataContainerUpdatingPostProcessor;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.AbstractScriptlet;
import adams.gui.scripting.ScriptingCommand;
import adams.gui.visualization.container.DataContainerPanel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractCommandProcessor
extends ConsoleObject
implements UndoHandler {
    private static final long serialVersionUID = 5363881783406430165L;
    protected AbstractScriptingEngine m_Owner;
    protected BasePanel m_BasePanel;
    protected Hashtable<String, AbstractScriptlet> m_Actions;

    public AbstractCommandProcessor() {
        this(null);
    }

    public AbstractCommandProcessor(AbstractScriptingEngine owner) {
        this.m_Owner = owner;
        this.initScriptlets();
    }

    protected void initScriptlets() {
        this.m_Actions = new Hashtable();
        String[] scriptlets = AbstractScriptlet.getScriptlets();
        for (int i = 0; i < scriptlets.length; ++i) {
            AbstractScriptlet scriptlet = AbstractScriptlet.forName(scriptlets[i]);
            scriptlet.setOwner(this);
            if (!this.m_Actions.containsKey(scriptlet.getAction())) {
                this.m_Actions.put(scriptlet.getAction(), scriptlet);
                continue;
            }
            this.getSystemErr().println("Duplicate actions:\n" + scriptlet.getClass().getName() + "\n" + this.m_Actions.get(scriptlet.getAction()).getClass().getName());
        }
    }

    public String globalInfo() {
        Vector scriptlets;
        int i;
        AbstractScriptlet scriptlet;
        StringBuilder result = new StringBuilder();
        Hashtable<String, Vector> sorted = new Hashtable<String, Vector>();
        Enumeration<AbstractScriptlet> enm = this.m_Actions.elements();
        while (enm.hasMoreElements()) {
            String[] required;
            scriptlet = enm.nextElement();
            Class[] requiredClasses = scriptlet.getRequirements();
            if (requiredClasses == null) {
                required = new String[]{""};
            } else {
                required = new String[requiredClasses.length];
                for (i = 0; i < requiredClasses.length; ++i) {
                    required[i] = requiredClasses[i].getName();
                }
            }
            for (i = 0; i < required.length; ++i) {
                if (!sorted.containsKey(required[i])) {
                    scriptlets = new Vector();
                    sorted.put(required[i], scriptlets);
                } else {
                    scriptlets = (Vector)sorted.get(required[i]);
                }
                scriptlets.add(scriptlet);
            }
        }
        Vector types = new Vector(sorted.keySet());
        Collections.sort(types);
        for (i = 0; i < types.size(); ++i) {
            scriptlets = (Vector)sorted.get(types.get(i));
            Collections.sort(scriptlets);
            if (((String)types.get(i)).length() == 0) {
                result.append("General actions:\n\n");
            } else {
                result.append("Actions for " + (String)types.get(i) + ":\n\n");
            }
            for (int n = 0; n < scriptlets.size(); ++n) {
                scriptlet = (AbstractScriptlet)scriptlets.get(n);
                result.append(scriptlet.getParameterDescription() + "\n");
                String[] desc = Utils.breakUp(scriptlet.getDescription(), 72);
                for (int m = 0; m < desc.length; ++m) {
                    result.append("\t" + desc[m] + "\n");
                }
                result.append("\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public void setOwner(AbstractScriptingEngine value) {
        this.m_Owner = value;
    }

    public AbstractScriptingEngine getOwner() {
        return this.m_Owner;
    }

    public abstract AbstractDatabaseConnection getDatabaseConnection();

    public void setBasePanel(BasePanel value) {
        this.m_BasePanel = value;
    }

    public BasePanel getBasePanel() {
        return this.m_BasePanel;
    }

    public DataContainerPanel getDataContainerPanel() {
        if (this.m_BasePanel != null && this.m_BasePanel instanceof DataContainerPanel) {
            return (DataContainerPanel)this.m_BasePanel;
        }
        return null;
    }

    public AbstractDataContainerUpdatingPostProcessor getDataContainerUpdatingPostProcessor() {
        return null;
    }

    protected Class getRequiredFlowClass() {
        return DataContainer.class;
    }

    public void setUndo(Undo value) {
        if (this.isUndoSupported()) {
            ((UndoHandler)((Object)this.getBasePanel())).setUndo(value);
        }
    }

    public Undo getUndo() {
        if (this.isUndoSupported()) {
            return ((UndoHandler)((Object)this.getBasePanel())).getUndo();
        }
        return null;
    }

    public boolean isUndoSupported() {
        return this.getBasePanel() instanceof UndoHandler && ((UndoHandler)((Object)this.getBasePanel())).isUndoSupported();
    }

    public StatusMessageHandler getStatusMessageHandler() {
        if (this.m_BasePanel instanceof StatusMessageHandler) {
            return (StatusMessageHandler)((Object)this.m_BasePanel);
        }
        return null;
    }

    protected abstract Object getUndoObject();

    protected void addUndoPoint(String statusMsg, String undoComment) {
        Object undo;
        if (this.isUndoSupported() && this.getUndo().isEnabled() && (undo = this.getUndoObject()) != null) {
            this.showStatus(statusMsg);
            this.getUndo().addUndo(undo, undoComment);
            this.showStatus("");
        }
    }

    protected void showStatus(String msg) {
        if (this.getStatusMessageHandler() != null) {
            this.getStatusMessageHandler().showStatus(msg);
        } else {
            this.getSystemOut().println(msg);
        }
    }

    protected AbstractScriptlet findScriptlet(String action) {
        return this.m_Actions.get(action);
    }

    protected String createRequirementError(Class requirement) {
        return "No " + requirement.getName() + " available!";
    }

    protected String checkRequirement(Class requirement) {
        String result = null;
        if (requirement == BasePanel.class) {
            result = this.getBasePanel() == null ? this.createRequirementError(requirement) : "";
        } else if (requirement == DataContainerPanel.class) {
            result = this.getDataContainerPanel() == null ? this.createRequirementError(requirement) : "";
        } else if (requirement == UndoHandler.class) {
            result = this.getBasePanel() == null || !(this.getBasePanel() instanceof UndoHandler) ? this.createRequirementError(requirement) : "";
        }
        return result;
    }

    protected String checkRequirements(AbstractScriptlet scriplet) {
        String result = "";
        Class[] requirements = scriplet.getRequirements();
        if (requirements != null) {
            for (int i = 0; i < requirements.length && (result = this.checkRequirement(requirements[i])) == null; ++i) {
            }
        }
        return result;
    }

    protected void setupScriptlet(AbstractScriptlet scriptlet) {
    }

    public String process(ScriptingCommand command) throws Exception {
        String result = null;
        this.setBasePanel(command.getBasePanel());
        String action = command.getCommand().trim().replaceAll(" .*", "");
        String options = command.getCommand().trim().replaceAll("^" + action + " ", "").trim();
        AbstractScriptlet scriptlet = this.findScriptlet(action);
        if (scriptlet == null) {
            result = this.getClass().getName() + ": Unknown action '" + action + "'!";
        }
        if (result == null) {
            String reqResult = this.checkRequirements(scriptlet);
            this.setupScriptlet(scriptlet);
            if (reqResult == null) {
                this.getSystemErr().println("WARNING: Action '" + action + "'/" + scriptlet.getClass().getName() + " has unmet requirement(s)!");
            } else if (reqResult.length() > 0) {
                result = reqResult;
            }
        }
        if (result == null) {
            result = scriptlet.process(options);
        }
        this.setBasePanel(null);
        return result;
    }
}

