/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.NamedContainer;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;

public class XYSequenceContainer
extends Container
implements ColorContainer,
VisibilityContainer,
NamedContainer {
    private static final long serialVersionUID = 4607026625578700170L;
    protected Color m_Color;
    protected boolean m_Visible;

    public XYSequenceContainer(XYSequenceContainerManager manager, XYSequence data) {
        super(manager, data);
    }

    protected void initialize() {
        super.initialize();
        this.m_Color = Color.WHITE;
        this.m_Visible = true;
    }

    public void assign(XYSequenceContainer c) {
        super.assign(c);
        if (c instanceof XYSequenceContainer) {
            this.m_Updating = true;
            this.setColor(c.getColor());
            this.setVisible(c.isVisible());
            this.m_Updating = false;
        }
    }

    public void setColor(Color value) {
        this.m_Color = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.UPDATE, this.getManager().indexOf(this)));
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    public void setVisible(boolean value) {
        this.m_Visible = value;
        if (!this.m_Updating && this.getManager() != null) {
            this.getManager().notifyDataChangeListeners(new DataChangeEvent(this.getManager(), DataChangeEvent.Type.VISIBILITY, this.getManager().indexOf(this)));
        }
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setData(XYSequence value) {
        this.setPayload(value);
    }

    public XYSequence getData() {
        return (XYSequence)this.getPayload();
    }

    public void setID(String value) {
        this.getData().setID(value);
    }

    public String getID() {
        return this.getData().getID();
    }

    public String getDisplayID() {
        return this.getID();
    }

    public int compareTo(Container o) {
        if (o == null) {
            return 1;
        }
        XYSequenceContainer c = (XYSequenceContainer)o;
        return this.getData().compareTo(c.getData());
    }

    public int hashCode() {
        return this.getData().hashCode();
    }

    public String toString() {
        return this.getData().toString();
    }
}

