/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.optimise.FitnessFunction;
import adams.optimise.OptData;

public abstract class AbstractOptimiser
extends OptionHandlingObject
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = -8047951676584896826L;
    protected Double m_bestf;
    protected OptData m_bestv;

    protected void initialize() {
        super.initialize();
        this.m_bestv = null;
        this.m_bestf = Double.NEGATIVE_INFINITY;
    }

    public void reset() {
        super.reset();
        this.m_bestv = null;
        this.m_bestf = Double.NEGATIVE_INFINITY;
    }

    public abstract OptData optimise(OptData var1, FitnessFunction var2);

    public synchronized void checkBest(Double fitness, OptData vars, FitnessFunction ff) {
        if (fitness > this.m_bestf) {
            this.m_bestf = new Double(fitness);
            if (this.m_bestv != null) {
                this.m_bestv.cleanUp();
            }
            this.m_bestv = vars.getClone();
            ff.newBest(fitness, vars);
        }
    }

    public void cleanUp() {
        if (this.m_bestv != null) {
            this.m_bestv.cleanUp();
        }
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractOptimiser shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractOptimiser shallowCopy(boolean expand) {
        return (AbstractOptimiser)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getOptimisers() {
        return ClassLister.getSingleton().getClassnames(AbstractOptimiser.class);
    }

    public static AbstractOptimiser forName(String classname, String[] options) {
        AbstractOptimiser result;
        try {
            result = (AbstractOptimiser)OptionUtils.forName(AbstractOptimiser.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractOptimiser forCommandLine(String cmdline) {
        return (AbstractOptimiser)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

