/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.core.CleanUpHandler;
import adams.core.CloneHandler;
import adams.optimise.OptVar;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptData
implements Serializable,
CleanUpHandler,
CloneHandler<OptData> {
    private static final long serialVersionUID = -8240249957587951006L;
    protected Hashtable<String, Double> m_data = new Hashtable();
    protected Hashtable<String, OptVar> m_vars = new Hashtable();

    @Override
    public OptData getClone() {
        OptData ret = new OptData();
        for (String key : this.getVarNames()) {
            ret.add(this.getVar(key).getClone());
        }
        for (String key : this.getDataNames()) {
            ret.set(key, this.get(key));
        }
        return ret;
    }

    public void set(String var, double val) {
        this.m_data.put(var, val);
    }

    public Set<String> getVarNames() {
        return this.m_vars.keySet();
    }

    public Set<String> getDataNames() {
        return this.m_data.keySet();
    }

    public void add(OptVar ov) {
        this.m_vars.put(ov.m_name, ov);
    }

    public OptVar getVar(String name) {
        return this.m_vars.get(name);
    }

    public Double get(String var) {
        return this.m_data.get(var);
    }

    @Override
    public void cleanUp() {
        this.m_data.clear();
        this.m_vars.clear();
    }

    public String toString() {
        String ret = "";
        for (String key : this.getVarNames()) {
            ret = ret + key + ":" + this.get(key) + ",";
        }
        return ret;
    }

    public String toVarString() {
        String ret = "";
        for (String key : this.getVarNames()) {
            ret = ret + key + ":" + this.getVar(key).toString() + ",";
        }
        return ret;
    }
}

