/*
 * EnumWithCustomDisplay.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

/**
 * For Enum classes that require a custom display string.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 998 $
 * @param <T> the type of enum
 */
public interface EnumWithCustomDisplay<T extends Enum> {

  /**
   * Returns the display string.
   *
   * @return		the display string
   */
  public String toDisplay();

  /**
   * Returns the raw enum string.
   *
   * @return		the raw enum string
   */
  public String toRaw();

  /**
   * Parses the given string and returns the associated enum.
   *
   * @param s		the string to parse
   * @return		the enum or null if not found
   */
  public T parse(String s);
}
