/*
 * BaseCharacter.java
 * Copyright (C) 2009-2010 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

/**
 * Wrapper for a Character object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1427 $
 */
public class BaseCharacter
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = 7599320288778710037L;

  /**
   * Initializes the string with length 0.
   */
  public BaseCharacter() {
    this("\u0000");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseCharacter(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		true if the string has length 1
   */
  public boolean isValid(String value) {
    return (value.length() == 1);
  }

  /**
   * Sets the string value.
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    m_Internal = value.charAt(0);
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return ((Character) m_Internal).toString();
  }

  /**
   * Returns the char value.
   *
   * @return		the char value
   */
  public char charValue() {
    return ((Character) m_Internal).charValue();
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "A single character.";
  }
}
