/**
 * OS.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.management;

/**
 * Helper class for operating system related stuff.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4122 $
 */
public class OS {

  /** whether the OS is Windows. */
  protected static Boolean m_IsWindows;

  /** whether the OS is Mac. */
  protected static Boolean m_IsMac;

  /**
   * Checks whether the operating system is Windows.
   *
   * @return		true if the OS is Windows flavor
   */
  public static synchronized boolean isWindows() {
    String	os;

    if (m_IsWindows == null) {
      os          = System.getProperty("os.name").toLowerCase();
      m_IsWindows = (os.indexOf("windows") > -1);
    }

    return m_IsWindows;
  }

  /**
   * Checks whether the operating system is Windows.
   *
   * @return		true if the OS is Windows flavor
   */
  public synchronized static boolean isMac() {
    String	os;

    if (m_IsMac == null) {
      os      = System.getProperty("os.name").toLowerCase();
      m_IsMac = os.startsWith("mac os");
    }

    return m_IsMac;
  }

}
