/**
 * ReportHandler.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.data.report;

/**
 * Interface for data containers that handle reports.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 305 $
 * @param <T> the type of the report
 */
public interface ReportHandler<T extends Report> {

  /**
   * Checks whether a report is present.
   *
   * @return		true if a report is present
   */
  public boolean hasReport();

  /**
   * Returns the report.
   *
   * @return		the report, can be null if none available
   */
  public T getReport();
}
