/**
 * Book.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Represents the "book" tag.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2504 $
 */
public class Book
  extends AbstractComplexElement {

  /** for serialization. */
  private static final long serialVersionUID = 6076552942458884097L;

  /**
   * Initializes the tag.
   */
  public Book() {
    super("book");
  }

  /**
   * Initializes the tag.
   *
   * @param title	the title of the book
   */
  public Book(String title) {
    this();
    add(new Title(title));
  }
}
