/**
 * GlobalActorReference.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.flow.core;

import adams.core.base.BaseString;

/**
 * Wrapper around the name of a global classifier (= string).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4243 $
 */
public class GlobalActorReference
  extends BaseString {

  /** for serialization. */
  private static final long serialVersionUID = 5082359039831645068L;

  /**
   * Initializes the string with length 0.
   */
  public GlobalActorReference() {
    this("");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public GlobalActorReference(String s) {
    super(s);
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "The name of the global actor.";
  }
}
