/**
 * PopupMenuHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core.dotnotationtree;

import javax.swing.JPopupMenu;

/**
 * Interface for classes that generate a popup menu in the class tree.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3584 $
 */
public interface PopupMenuHandler {

  /**
   * Returns the popup menu for an item node.
   *
   * @param node	the item node
   * @param isLeaf	whether the node is the last node in this branch,
   * 			excluding any info nodes
   * @return		the popup or null if no popup available
   */
  public JPopupMenu getItemNodePopup(DotNotationNode node, boolean isLeaf);

  /**
   * Returns the popup menu for an info node.
   *
   * @param node	the info node
   * @return		the popup or null if no popup available
   */
  public JPopupMenu getInfoNodePopup(AbstractInfoNode node);
}
