/**
 * FloatEditor.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.goe;

import adams.gui.core.NumberTextField;

/**
 * A custom editor for Floats.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 638 $
 */
public class FloatEditor
  extends AbstractFloatingPointNumberEditor {

  /**
   * Initializes the editor.
   */
  public FloatEditor() {
    super();

    m_CurrentValue = new Float(0.0f);
  }

  /**
   * Returns the type of number to check for.
   *
   * @return		the type of number
   */
  protected NumberTextField.Type getType() {
    return NumberTextField.Type.FLOAT;
  }

  /**
   * Set (or change) the object that is to be edited.  Primitive types such
   * as "int" must be wrapped as the corresponding object type such as
   * "java.lang.Float".
   *
   * @param value The new target object to be edited.  Note that this
   *     object should not be modified by the PropertyEditor, rather
   *     the PropertyEditor should create a new object to hold any
   *     modified value.
   */
  public void setValue(Object value) {
    m_CurrentValue = new Float(((Number) value).floatValue());
    firePropertyChange();
  }

  /**
   * Gets the property value.
   *
   * @return The value of the property.  Primitive types such as "int" will
   * be wrapped as the corresponding object type such as "java.lang.Float".
   */

  public Object getValue() {
    return m_CurrentValue;
  }

  /**
   * Parses the string and returns an object of the correct class.
   *
   * @param text	the string to parse
   * @return		the generated object
   * @throws IllegalArgumentException	if parsing fails
   */
  protected Object parse(String text) throws IllegalArgumentException {
    Object	result;

    try {
      if (text.length() == 0)
	text = "0";
      result = new Float(text);
    }
    catch (Exception e) {
      throw new IllegalArgumentException(e);
    }

    return result;
  }
}
