/**
 * FilterOverlay.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.scripting;

/**
 * Abstract filter scriptlet (overlays the containers).
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 501 $
 */
public class FilterOverlay
  extends AbstractFilterScriptlet {

  /** for serialization. */
  private static final long serialVersionUID = -8718688474577262409L;

  /** the action to execute. */
  public final static String ACTION = "filter-overlay";

  /**
   * Returns the action string used in the command processor.
   *
   * @return		the action string
   */
  public String getAction() {
    return ACTION;
  }

  /**
   * Returns the full description of the action.
   *
   * @return		the full description
   */
  public String getDescription() {
    return "Executes the filter on the visible data containers, overlays the original ones.";
  }

  /**
   * Processes the options.
   *
   * @param options	additional/optional options for the action
   * @return		null if no error, otherwise error message
   * @throws Exception 	if something goes wrong
   */
  public String process(String options) throws Exception {
    return process(options, true);
  }
}
