/*
 * GenerateParser.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */

package adams.parser;

import java.io.File;

/**
 * Generates Java code from the Parser.cup and Scanner.jflex files.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2158 $
 */
public class GenerateParser {

  /**
   * Runs the generator from command-line.
   * <p/>
   * Expects one argument: directory that that contains the Scanner.jflex and 
   *                       Parser.cup files
   *
   * @param args	the command-line options
   * @throws Exception  if anything goes wrong
   */
  public static void main(String[] args) throws Exception {
    // test arguments
    if (args.length < 1) {
      System.err.println();
      System.err.println("No directory provided!");
      System.err.println();
      System.err.println("Usage: " + GenerateParser.class.getClass().getName() + " <parser-dir> [<parser-dir> ...]");
      System.exit(1);
    }
    for (int i = 0; i < args.length; i++) {
      File dir = new File(args[i]);
      if (!dir.exists()) {
        System.err.println();
        System.err.println("Directory does not exist: " + dir);
        System.err.println();
        System.err.println("Usage: " + GenerateParser.class.getClass().getName() + " <parser-dir>");
        System.exit(2);
      }

      System.out.println("Generating parser: " + dir);

      String[] options;

      // JFlex
      options = new String[]{
        "--jlex",
        "--quiet",
        "--nobak",
        "--outdir",
        dir.getAbsolutePath(),
        dir.getAbsolutePath() + "/Scanner.jflex"
      };
      JFlex.Main.main(options);
      
      // java-cup
      options = new String[]{
        "-parser",
        "Parser",
        "-interface",
        "-nosummary",
        "-destdir",
        dir.getAbsolutePath(),
        dir.getAbsolutePath() + "/Parser.cup"
      };
      java_cup.Main.main(options);
    }
  }
}
