/*
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Scanner.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.parser.templatesuggestion;

import java_cup.runtime.SymbolFactory;
import java.io.*;
import java.util.*;

/**
 * A scanner for date expressions.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision$
 */
%%
%unicode
%cup
%public
%class Scanner
%{
  // Author: FracPete (fracpete at waikato dot ac dot nz)
  // Version: $Revision$
  protected SymbolFactory sf;

  public Scanner(InputStream r, SymbolFactory sf){
    this(r);
    this.sf = sf;
  }
%}
%eofval{
    return sf.newSymbol("EOF",sym.EOF);
%eofval}

%{
  StringBuilder string = new StringBuilder();
%}

%state STRING

%%
<YYINITIAL> {
  // keywords
  "AND"         { return sf.newSymbol("And",         sym.AND); }
  "BEFORE"      { return sf.newSymbol("Before",      sym.BEFORE); }
  "AFTER"       { return sf.newSymbol("After",       sym.AFTER); }
  "PARENT"      { return sf.newSymbol("Parent" ,     sym.PARENT); }
  "ISFIRST"     { return sf.newSymbol("First",       sym.ISFIRST); }
  "ISLAST"      { return sf.newSymbol("First",       sym.ISLAST); }
  "STANDALONE"  { return sf.newSymbol("Standalone",  sym.STANDALONE); }
  "SOURCE"      { return sf.newSymbol("Source",      sym.SOURCE); }
  "TRANSFORMER" { return sf.newSymbol("Transformer", sym.TRANSFORMER); }
  "SINK"        { return sf.newSymbol("Sink",        sym.SINK); }
  "IS"          { return sf.newSymbol("Is",          sym.IS); }
  "NOT"         { return sf.newSymbol("Not",         sym.NOT); }
  "IF"          { return sf.newSymbol("If",          sym.IF); }
  "THEN"        { return sf.newSymbol("Then",        sym.THEN); }
  "TRUE"        { return sf.newSymbol("True",        sym.TRUE); }
  "FALSE"       { return sf.newSymbol("False",       sym.FALSE); }

  // classname
  ([a-zA-Z_$][a-zA-Z\d_$]*\.)*[a-zA-Z_$][a-zA-Z\d_$]* { return sf.newSymbol("Classname", sym.CLASSNAME, new String(yytext())); }

  // whitespaces
  [ \r\n\t\f] { /* ignore white space. */ }

  // strings
  \"  { string.setLength(0); yybegin(STRING); }
}

<STRING> {
  \"            { yybegin(YYINITIAL);
                  return sf.newSymbol("Classname", sym.CLASSNAME, string.toString()); }
  [^\n\r\"\\]+  { string.append(yytext()); }
  \\t           { string.append('\t'); }
  \\n           { string.append('\n'); }
  \\r           { string.append('\r'); }
  \\\"          { string.append('\"'); }
  \\            { string.append('\\'); }
}

// catch all
. { System.err.println("Illegal character: "+yytext()); }
