/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseObjectTestCase;
import adams.core.base.BaseDateTime;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BaseDateTimeTest
extends AbstractBaseObjectTestCase<BaseDateTime> {
    public BaseDateTimeTest(String name) {
        super(name);
    }

    @Override
    protected BaseDateTime getDefault() {
        return new BaseDateTime();
    }

    @Override
    protected BaseDateTime getCustom(String s) {
        return new BaseDateTime(s);
    }

    @Override
    protected String getTypicalValue() {
        return "2010-06-01 12:34:00";
    }

    public void testInfinity() {
        BaseDateTime b = new BaseDateTime(this.getTypicalValue());
        BaseDateTimeTest.assertFalse((boolean)b.isInfinity());
        BaseDateTimeTest.assertFalse((boolean)b.isInfinityPast());
        BaseDateTimeTest.assertFalse((boolean)b.isInfinityFuture());
        b = new BaseDateTime("+INF");
        BaseDateTimeTest.assertTrue((boolean)b.isInfinity());
        BaseDateTimeTest.assertFalse((boolean)b.isInfinityPast());
        BaseDateTimeTest.assertTrue((boolean)b.isInfinityFuture());
        b = new BaseDateTime("-INF");
        BaseDateTimeTest.assertTrue((boolean)b.isInfinity());
        BaseDateTimeTest.assertTrue((boolean)b.isInfinityPast());
        BaseDateTimeTest.assertFalse((boolean)b.isInfinityFuture());
    }

    public static Test suite() {
        return new TestSuite(BaseDateTimeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseDateTimeTest.runTest(BaseDateTimeTest.suite());
    }
}

