/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionProducerTestCase;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.sink.DumpFile;

public class ArrayProducerTest
extends AbstractOptionProducerTestCase {
    public ArrayProducerTest(String name) {
        super(name);
    }

    public void testProduceSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        ArrayProducer producer = new ArrayProducer();
        producer.produce((OptionHandler)handler);
        ArrayProducerTest.assertEquals((String)"getOutput() differs", (String)"adams.flow.sink.DumpFile,-D,1,-output,${TMP}/dumpfile.csv,-append", (String)Utils.arrayToString((Object)producer.getOutput()));
        ArrayProducerTest.assertEquals((String)"toString() differs", (String)"adams.flow.sink.DumpFile -D 1 -output ${TMP}/dumpfile.csv -append", (String)producer.toString());
    }

    public void testProduceDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        ArrayProducer producer = new ArrayProducer();
        producer.produce((OptionHandler)handler);
        ArrayProducerTest.assertEquals((String)"getOutput() differs", (String)"adams.data.filter.MultiFilter,-D,1,-filter,adams.data.filter.PassThrough -D 2,-filter,adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough", (String)Utils.arrayToString((Object)producer.getOutput()));
        ArrayProducerTest.assertEquals((String)"toString() differs", (String)"adams.data.filter.MultiFilter -D 1 -filter \"adams.data.filter.PassThrough -D 2\" -filter \"adams.data.filter.MultiFilter -D 3 -filter adams.data.filter.PassThrough\"", (String)producer.toString());
    }

    public void testProduceDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        ArrayProducer producer = new ArrayProducer();
        producer.produce((OptionHandler)handler);
        ArrayProducerTest.assertEquals((String)"getOutput() differs", (String)"adams.data.filter.BaselineCorrection,-baseline,adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough", (String)Utils.arrayToString((Object)producer.getOutput()));
        ArrayProducerTest.assertEquals((String)"toString() differs", (String)"adams.data.filter.BaselineCorrection -baseline \"adams.data.baseline.SlidingWindow -D 2 -baseline adams.data.baseline.PassThrough\"", (String)producer.toString());
    }
}

