/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.EnumWithCustomDisplay;
import adams.core.base.BaseString;
import adams.core.option.AbstractArgumentOptionTest;
import adams.core.option.AbstractOptionTest;
import adams.core.option.IntegerOptionTest;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ClassOptionTest
extends AbstractArgumentOptionTest {
    public ClassOptionTest(String name) {
        super(name);
    }

    @Override
    protected OptionHandler getOptionHandler() {
        return new ClassOptionClass();
    }

    public static Test suite() {
        return new TestSuite(ClassOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ClassOptionTest.runTest(ClassOptionTest.suite());
    }

    public static class ClassOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = 5310369882567819648L;
        protected SimpleEnum m_SimpleEnum;
        protected SimpleEnum[] m_SimpleEnumArray;
        protected EnumCustomDisplay m_EnumCustomDisplay;
        protected EnumCustomDisplay[] m_EnumCustomDisplayArray;
        protected BaseString m_BaseString;
        protected BaseString[] m_BaseStringArray;
        protected IntegerOptionTest.IntegerOptionClass m_IntegerOptionClass;
        protected IntegerOptionTest.IntegerOptionClass[] m_IntegerOptionClassArray;

        @Override
        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("simple-enum", "simpleEnum", (Object)SimpleEnum.FIRST);
            this.m_OptionManager.add("simple-enum-array", "simpleEnumArray", (Object)new SimpleEnum[]{SimpleEnum.FIRST, SimpleEnum.SECOND});
            this.m_OptionManager.add("enum-custom", "enumCustomDisplay", (Object)EnumCustomDisplay.FIRST);
            this.m_OptionManager.add("enum-custom-array", "enumCustomDisplayArray", (Object)new EnumCustomDisplay[]{EnumCustomDisplay.FIRST, EnumCustomDisplay.SECOND});
            this.m_OptionManager.add("base-string", "baseString", (Object)new BaseString("hello"));
            this.m_OptionManager.add("base-string-array", "baseStringArray", (Object)new BaseString[]{new BaseString("hello"), new BaseString("world")});
            this.m_OptionManager.add("integer-option", "integerOptionClass", (Object)new IntegerOptionTest.IntegerOptionClass());
            this.m_OptionManager.add("integer-option-array", "integerOptionClassArray", (Object)new IntegerOptionTest.IntegerOptionClass[]{new IntegerOptionTest.IntegerOptionClass(), new IntegerOptionTest.IntegerOptionClass()});
        }

        public void setSimpleEnum(SimpleEnum value) {
            this.m_SimpleEnum = value;
        }

        public SimpleEnum getSimpleEnum() {
            return this.m_SimpleEnum;
        }

        public String simpleEnumTipText() {
            return "simpleEnum";
        }

        public void setSimpleEnumArray(SimpleEnum[] value) {
            this.m_SimpleEnumArray = value;
        }

        public SimpleEnum[] getSimpleEnumArray() {
            return this.m_SimpleEnumArray;
        }

        public String simpleEnumArrayTipText() {
            return "simpleEnumArray";
        }

        public void setEnumCustomDisplay(EnumCustomDisplay value) {
            this.m_EnumCustomDisplay = value;
        }

        public EnumCustomDisplay getEnumCustomDisplay() {
            return this.m_EnumCustomDisplay;
        }

        public String enumCustomDisplayTipText() {
            return "enumCustomDisplay";
        }

        public void setEnumCustomDisplayArray(EnumCustomDisplay[] value) {
            this.m_EnumCustomDisplayArray = value;
        }

        public EnumCustomDisplay[] getEnumCustomDisplayArray() {
            return this.m_EnumCustomDisplayArray;
        }

        public String enumCustomDisplayArrayTipText() {
            return "enumCustomDisplayArray";
        }

        public void setBaseString(BaseString value) {
            this.m_BaseString = value;
        }

        public BaseString getBaseString() {
            return this.m_BaseString;
        }

        public String baseStringTipText() {
            return "baseString";
        }

        public void setBaseStringArray(BaseString[] value) {
            this.m_BaseStringArray = value;
        }

        public BaseString[] getBaseStringArray() {
            return this.m_BaseStringArray;
        }

        public String baseStringArrayTipText() {
            return "baseStringArray";
        }

        public void setIntegerOptionClass(IntegerOptionTest.IntegerOptionClass value) {
            this.m_IntegerOptionClass = value;
        }

        public IntegerOptionTest.IntegerOptionClass getIntegerOptionClass() {
            return this.m_IntegerOptionClass;
        }

        public String integerOptionClassTipText() {
            return "integerOptionClass";
        }

        public void setIntegerOptionClassArray(IntegerOptionTest.IntegerOptionClass[] value) {
            this.m_IntegerOptionClassArray = value;
        }

        public IntegerOptionTest.IntegerOptionClass[] getIntegerOptionClassArray() {
            return this.m_IntegerOptionClassArray;
        }

        public String integerOptionClassArrayTipText() {
            return "integerOptionClassArray";
        }
    }

    public static enum EnumCustomDisplay implements EnumWithCustomDisplay<EnumCustomDisplay>
    {
        FIRST("1st"),
        SECOND("2nd"),
        THIRD("3rd");

        private String m_Display;
        private String m_Raw;

        private EnumCustomDisplay(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public EnumCustomDisplay parse(String s) {
            EnumCustomDisplay result = null;
            try {
                result = EnumCustomDisplay.valueOf(s);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (EnumCustomDisplay ecd : EnumCustomDisplay.values()) {
                    if (!ecd.toDisplay().equals(s)) continue;
                    result = ecd;
                    break;
                }
            }
            return result;
        }
    }

    public static enum SimpleEnum {
        FIRST,
        SECOND,
        THIRD;

    }
}

