/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionProducerTestCase;
import adams.core.option.NestedProducer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.filter.AbstractFilter;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.flow.sink.DumpFile;

public class NestedProducerTest
extends AbstractOptionProducerTestCase {
    public NestedProducerTest(String name) {
        super(name);
    }

    public void testSimple() {
        DumpFile handler = new DumpFile();
        handler.setDebugLevel(1);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.csv"));
        handler.setAppend(true);
        NestedProducer producer = new NestedProducer();
        producer.setOutputProlog(false);
        producer.produce((OptionHandler)handler);
        NestedProducerTest.assertEquals((String)"getOutput() differs", (String)"[adams.flow.sink.DumpFile, [-D, 1, -output, ${TMP}/dumpfile.csv, -append]]", (String)("" + producer.getOutput()));
        NestedProducerTest.assertEquals((String)"toString() differs", (String)"adams.flow.sink.DumpFile\n\t-D\n\t1\n\t-output\n\t${TMP}/dumpfile.csv\n\t-append\n", (String)producer.toString());
    }

    public void testDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setDebugLevel(1);
        AbstractFilter[] filters = new AbstractFilter[2];
        filters[0] = new PassThrough();
        filters[0].setDebugLevel(2);
        filters[1] = new MultiFilter();
        filters[1].setDebugLevel(3);
        handler.setSubFilters(filters);
        NestedProducer producer = new NestedProducer();
        producer.setOutputProlog(false);
        producer.produce((OptionHandler)handler);
        NestedProducerTest.assertEquals((String)"getOutput() differs", (String)"[adams.data.filter.MultiFilter, [-D, 1, -filter, [adams.data.filter.PassThrough, [-D, 2]], -filter, [adams.data.filter.MultiFilter, [-D, 3, -filter, [adams.data.filter.PassThrough, []]]]]]", (String)("" + producer.getOutput()));
        NestedProducerTest.assertEquals((String)"toString() differs", (String)"adams.data.filter.MultiFilter\n\t-D\n\t1\n\t-filter\n\t\tadams.data.filter.PassThrough\n\t\t\t-D\n\t\t\t2\n\t-filter\n\t\tadams.data.filter.MultiFilter\n\t\t\t-D\n\t\t\t3\n\t\t\t-filter\n\t\t\t\tadams.data.filter.PassThrough\n", (String)producer.toString());
    }

    public void testDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setDebugLevel(2);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        NestedProducer producer = new NestedProducer();
        producer.setOutputProlog(false);
        producer.produce((OptionHandler)handler);
        NestedProducerTest.assertEquals((String)"getOutput() differs", (String)"[adams.data.filter.BaselineCorrection, [-baseline, [adams.data.baseline.SlidingWindow, [-D, 2, -baseline, [adams.data.baseline.PassThrough, []]]]]]", (String)("" + producer.getOutput()));
        NestedProducerTest.assertEquals((String)"toString() differs", (String)"adams.data.filter.BaselineCorrection\n\t-baseline\n\t\tadams.data.baseline.SlidingWindow\n\t\t\t-D\n\t\t\t2\n\t\t\t-baseline\n\t\t\t\tadams.data.baseline.PassThrough\n", (String)producer.toString());
    }
}

