/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.Report;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;

public abstract class AbstractReportWriterTestCase<A extends AbstractReportWriter, D extends Report>
extends AbstractDatabaseTestCase {
    public AbstractReportWriterTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/io/output/data");
    }

    protected D load(String filename) {
        this.m_TestHelper.copyResourceToTmp(filename);
        DefaultSimpleReportReader reader = new DefaultSimpleReportReader();
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        Report report = (Report)reader.read().firstElement();
        Report result = new Report();
        result.assign(report);
        this.m_TestHelper.deleteFileFromTmp(filename);
        return (D)result;
    }

    protected boolean save(D data, A scheme, String filename) {
        TmpFile file = new TmpFile(filename);
        scheme.setOutput((PlaceholderFile)file);
        scheme.write(data);
        return file.exists();
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract A[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractReportWriter[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractReportWriterTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractReportWriterTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            AbstractReportWriter current = (AbstractReportWriter)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractReportWriterTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            D data = this.load(input[i]);
            AbstractReportWriterTestCase.assertNotNull((String)"Failed to read data?", data);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(data, current, output[i]);
            AbstractReportWriterTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, ignored);
        AbstractReportWriterTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

