/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.condition.AbstractCondition;
import adams.flow.condition.AbstractConditionTestCase;
import adams.flow.condition.FileExists;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FileExistsTest
extends AbstractConditionTestCase {
    public FileExistsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("bolts2.csv");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("bolts2.csv");
        super.tearDown();
    }

    @Override
    protected AbstractCondition[] getRegressionSetups() {
        FileExists[] result = new FileExists[6];
        result[0] = new FileExists();
        result[0].setFile((PlaceholderFile)new TmpFile("bolts.csv"));
        result[1] = new FileExists();
        result[1].setFile((PlaceholderFile)new TmpFile("bolts2.csv"));
        result[2] = new FileExists();
        result[2].setFile(new PlaceholderFile("${TMP}"));
        result[3] = new FileExists();
        result[3].setFile((PlaceholderFile)new TmpFile("bolts.csv"));
        result[3].setInvert(true);
        result[4] = new FileExists();
        result[4].setFile((PlaceholderFile)new TmpFile("bolts2.csv"));
        result[4].setInvert(true);
        result[5] = new FileExists();
        result[5].setFile(new PlaceholderFile("${TMP}/blah"));
        result[5].setInvert(true);
        return result;
    }

    public static Test suite() {
        return new TestSuite(FileExistsTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        FileExistsTest.runTest(FileExistsTest.suite());
    }
}

