/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.condition.AbstractCondition;
import adams.flow.condition.AbstractConditionTestCase;
import adams.flow.condition.FileExists;
import adams.flow.condition.MultiCondition;
import adams.flow.condition.True;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MultiConditionTest
extends AbstractConditionTestCase {
    public MultiConditionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("bolts2.csv");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("bolts2.csv");
        super.tearDown();
    }

    @Override
    protected AbstractCondition[] getRegressionSetups() {
        MultiCondition[] result = new MultiCondition[2];
        FileExists exists = new FileExists();
        exists.setFile((PlaceholderFile)new TmpFile("bolts.csv"));
        True tr = new True();
        result[0] = new MultiCondition();
        result[0].setSubConditions(new AbstractCondition[]{exists, tr});
        exists = new FileExists();
        exists.setFile((PlaceholderFile)new TmpFile("bolts2.csv"));
        tr = new True();
        result[1] = new MultiCondition();
        result[1].setSubConditions(new AbstractCondition[]{exists, tr});
        return result;
    }

    public static Test suite() {
        return new TestSuite(MultiConditionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MultiConditionTest.runTest(MultiConditionTest.suite());
    }
}

