/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Breakpoint;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BreakpointTest
extends AbstractFlowTest {
    public BreakpointTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ForLoop fl = new ForLoop();
        fl.setLoopLower(1);
        fl.setLoopUpper(30);
        fl.setLoopStep(1);
        Breakpoint bp = new Breakpoint();
        bp.setExpression("false");
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{fl, bp, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(BreakpointTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BreakpointTest.runTest(BreakpointTest.suite());
    }
}

