/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.ifthenelse.AbstractIfThenElseCondition;
import adams.flow.condition.ifthenelse.Expression;
import adams.flow.control.Flow;
import adams.flow.control.IfThenElse;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.ForLoop;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class IfThenElseTest
extends AbstractFlowTest {
    public IfThenElseTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile_default_then.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_default_else.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_custom_then.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_custom_else.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile_default_then.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_default_else.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_custom_then.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_custom_else.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        ForLoop fl = new ForLoop();
        DumpFile df_default_then = new DumpFile();
        df_default_then.setAppend(true);
        df_default_then.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_default_then.txt"));
        DumpFile df_default_else = new DumpFile();
        df_default_else.setAppend(true);
        df_default_else.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_default_else.txt"));
        IfThenElse ite_default = new IfThenElse();
        ite_default.setThenActor((AbstractActor)df_default_then);
        ite_default.setElseActor((AbstractActor)df_default_else);
        Tee tee_default = new Tee();
        tee_default.add(0, (AbstractActor)ite_default);
        DumpFile df_custom_then = new DumpFile();
        df_custom_then.setAppend(true);
        df_custom_then.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_custom_then.txt"));
        DumpFile df_custom_else = new DumpFile();
        df_custom_else.setAppend(true);
        df_custom_else.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_custom_else.txt"));
        IfThenElse ite_custom = new IfThenElse();
        Expression cond = new Expression();
        cond.setExpression("(X > 5)");
        ite_custom.setCondition((AbstractIfThenElseCondition)cond);
        ite_custom.setThenActor((AbstractActor)df_custom_then);
        ite_custom.setElseActor((AbstractActor)df_custom_else);
        Tee tee_custom = new Tee();
        tee_custom.add(0, (AbstractActor)ite_custom);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{fl, tee_default, tee_custom});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile_default_then.txt"), new TmpFile("dumpfile_default_else.txt"), new TmpFile("dumpfile_custom_then.txt"), new TmpFile("dumpfile_custom_else.txt")});
    }

    public static Test suite() {
        return new TestSuite(IfThenElseTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        IfThenElseTest.runTest(IfThenElseTest.suite());
    }
}

