/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.random.AbstractRandomNumberGenerator;
import adams.data.random.JavaRandomInt;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Switch;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SwitchTest
extends AbstractFlowTest {
    public SwitchTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile-300.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-600.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-default.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        rng.setGenerator((AbstractRandomNumberGenerator)new JavaRandomInt());
        DumpFile df300 = new DumpFile();
        df300.setAppend(true);
        df300.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-300.txt"));
        DumpFile df600 = new DumpFile();
        df600.setAppend(true);
        df600.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-600.txt"));
        DumpFile dfDef = new DumpFile();
        dfDef.setAppend(true);
        dfDef.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-default.txt"));
        Switch sw = new Switch();
        sw.setExpressions(new BaseString[]{new BaseString("X < 300"), new BaseString("X < 600")});
        sw.setCases(new AbstractActor[]{df300, df600, dfDef});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{rng, sw});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile-300.txt"), new TmpFile("dumpfile-600.txt"), new TmpFile("dumpfile-default.txt")});
    }

    public static Test suite() {
        return new TestSuite(SwitchTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SwitchTest.runTest(SwitchTest.suite());
    }
}

