/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.VariableName;
import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.AbstractCondition;
import adams.flow.condition.FileExists;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.Variable;
import adams.flow.standalone.ConditionalStandalone;
import adams.flow.standalone.DeleteFile;
import adams.flow.standalone.SetVariable;
import adams.test.TmpDirectory;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DeleteFileTest
extends AbstractFlowTest {
    public DeleteFileTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    @Override
    public AbstractActor getActor() {
        FileExists fe = new FileExists();
        fe.setFile((PlaceholderFile)new TmpFile("bolts.csv"));
        SetVariable sv = new SetVariable();
        sv.setVariableName(new VariableName("file_exists"));
        sv.setVariableValue("yes");
        ConditionalStandalone cond = new ConditionalStandalone();
        cond.setCondition((AbstractCondition)fe);
        cond.setActor((AbstractActor)sv);
        DeleteFile df = new DeleteFile();
        df.setDirectory((PlaceholderDirectory)new TmpDirectory());
        df.setRegExp(new BaseRegExp("bolts.csv"));
        SetVariable sv2 = new SetVariable();
        sv2.setVariableName(new VariableName("file_exists"));
        sv2.setVariableValue("no");
        Variable var = new Variable();
        var.setVariableName(new VariableName("file_exists"));
        DumpFile dump = new DumpFile();
        dump.setAppend(true);
        dump.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{cond, df, sv2, var, dump});
        flow.getVariables().set("file_exists", "no");
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(DeleteFileTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DeleteFileTest.runTest(DeleteFileTest.suite());
    }
}

