/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.management.JMap;
import adams.core.management.ProcessUtils;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.db.OptionHandlingDatabaseObject;
import adams.env.Environment;
import java.util.Date;
import javax.swing.SwingWorker;

public abstract class AbstractStressTest
extends OptionHandlingDatabaseObject {
    private static final long serialVersionUID = -2535320030771462923L;
    protected PlaceholderFile m_Log;
    protected int m_NumIterations;
    protected int m_NumSeconds;
    protected BaseRegExp m_RegExp;
    protected Boolean m_LogIsFile;
    protected Boolean m_UseJmap;
    protected String m_JmapOptions;
    protected boolean m_Excecuted;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("log", "log", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("num-iter", "numIterations", (Object)10);
        this.m_OptionManager.add("num-sec", "numSeconds", (Object)10);
        this.m_OptionManager.add("reg-exp", "regExp", (Object)new BaseRegExp(".*adams\\..*"));
        this.m_OptionManager.add("jmap", "useJmap", (Object)false);
        this.m_OptionManager.add("jmap-options", "jmapOptions", (Object)"");
    }

    protected void reset() {
        super.reset();
        this.m_LogIsFile = null;
    }

    public void setLog(PlaceholderFile value) {
        this.m_Log = value;
        this.reset();
    }

    public PlaceholderFile getLog() {
        return this.m_Log;
    }

    public String logTipText() {
        return "The optional log file to store the jmap output in; gets ignored if pointing to a directory.";
    }

    public void setNumIterations(int value) {
        this.m_NumIterations = value;
        this.reset();
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform.";
    }

    public void setNumSeconds(int value) {
        this.m_NumSeconds = value;
        this.reset();
    }

    public int getNumSeconds() {
        return this.m_NumSeconds;
    }

    public String numSecondsTipText() {
        return "The number of seconds before stopping the thread again; use -1 to let thread finish.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the jmap output must match.";
    }

    public void setUseJmap(boolean value) {
        this.m_UseJmap = value;
        this.reset();
    }

    public boolean getUseJmap() {
        return this.m_UseJmap;
    }

    public String useJmapTipText() {
        return "Whether to run jmap.";
    }

    public void setJmapOptions(String value) {
        this.m_JmapOptions = value;
        this.reset();
    }

    public String getJmapOptions() {
        return this.m_JmapOptions;
    }

    public String jmapOptionsTipText() {
        return "The commandline options for jmap, eg '-histo:live'.";
    }

    public synchronized void log(String msg) {
        boolean append;
        if (this.m_LogIsFile == null) {
            this.m_LogIsFile = !this.m_Log.isDirectory();
            append = false;
        } else {
            append = true;
        }
        if (this.m_LogIsFile.booleanValue()) {
            FileUtils.writeToFile((String)this.m_Log.getAbsolutePath(), (Object)msg, (boolean)append);
        }
        this.getSystemOut().println(msg);
    }

    protected boolean preExecute() {
        this.establishDatabaseConnection();
        return this.m_dbc.isConnected();
    }

    protected abstract Worker setupWorker(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        this.log("Setup: " + OptionUtils.getCommandLine((Object)((Object)this)));
        this.log("Start: " + new Date());
        for (int i = 0; i < this.m_NumIterations; ++i) {
            Worker worker = this.setupWorker(i);
            worker.execute();
            if (this.m_NumSeconds > -1) {
                int n = 0;
                while (i < this.m_NumSeconds && !worker.hasFinished()) {
                    for (int m = 0; m < 5 && !worker.hasFinished(); ++m) {
                        try {
                            AbstractStressTest abstractStressTest = this;
                            synchronized (abstractStressTest) {
                                ((Object)((Object)this)).wait(200L);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++n;
                }
                if (worker.hasFinished()) continue;
                worker.stopExecution();
                continue;
            }
            while (!worker.hasFinished()) {
                try {
                    AbstractStressTest e = this;
                    synchronized (e) {
                        ((Object)((Object)this)).wait(200L);
                    }
                }
                catch (Exception e) {
                }
            }
        }
        this.log("\nFinish: " + new Date());
    }

    protected void postExecute() {
    }

    public void execute() {
        if (this.preExecute()) {
            this.m_Excecuted = true;
            this.doExecute();
        }
        this.postExecute();
    }

    public static AbstractStressTest forName(String classname, String[] options) {
        AbstractStressTest result;
        try {
            result = (AbstractStressTest)((Object)OptionUtils.forName(AbstractStressTest.class, (String)classname, (String[])options));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static void runStressTester(Class env, Class tester, String[] args) {
        Environment.setEnvironmentClass((Class)env);
        AbstractStressTest testerInst = AbstractStressTest.forName(tester.getName(), args);
        try {
            if (OptionUtils.helpRequested((String[])args)) {
                System.out.println("\nHelp requested:\n");
                System.out.println(OptionUtils.list((OptionHandler)testerInst));
            } else {
                ArrayConsumer.setOptions((OptionHandler)testerInst, (String[])args);
                testerInst.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static abstract class Worker
    extends SwingWorker {
        protected AbstractStressTest m_Owner;
        protected int m_Iteration;
        protected boolean m_Finished;

        public Worker(AbstractStressTest owner, int iteration) {
            this.m_Owner = owner;
            this.m_Iteration = iteration;
        }

        protected void runJmap() {
            String out = JMap.execute((String)this.m_Owner.getJmapOptions(), (long)ProcessUtils.getVirtualMachinePID());
            String[] lines = out.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!this.m_Owner.getRegExp().isMatch(lines[i])) continue;
                this.m_Owner.log("   " + lines[i]);
            }
        }

        @Override
        protected void done() {
            this.m_Finished = true;
            this.m_Owner.log("\nIteration " + (this.m_Iteration + 1) + "/" + this.m_Owner.getNumIterations());
            if (this.m_Owner.getUseJmap()) {
                this.runJmap();
            }
            this.m_Owner = null;
            super.done();
        }

        public boolean hasFinished() {
            return this.m_Finished;
        }

        public abstract void stopExecution();
    }
}

