/**
 * OutputProcessStream.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.management;

import java.io.BufferedReader;
import java.io.InputStreamReader;

/**
 * For capturing the output of stdout or stderr of a running Process and
 * outputting it on stdout or stderr.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4031 $
 */
public class OutputProcessStream
  implements Runnable {

  /** whether it is still running. */
  protected boolean m_Running;

  /** the ID of the process. */
  protected String m_ID;

  /** whether to output to stdout. */
  protected boolean m_StdOut;

  /** the reader. */
  protected BufferedReader m_Reader;

  /**
   * Initializes the object.
   *
   * @param process	the process to print the output from
   * @param stdout	if true then stdout is used, otherwise stderr
   */
  public OutputProcessStream(Process process, boolean stdout) {
    super();

    m_StdOut = stdout;
    m_ID     = "" + process.hashCode();
    if (m_StdOut)
      m_Reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
    else
      m_Reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
  }

  /**
   * Prints the output from the process.
   */
  public void run() {
    String	line;

    m_Running = true;

    while (m_Running) {
      try {
        line = m_Reader.readLine();
        if (line != null) {
          if (m_StdOut)
            System.out.println(line);
          else
            System.err.println(line);
        }
        m_Running = m_Running && (line != null);
      }
      catch (Exception e) {
        // ignored
      }
    }
  }

  /**
   * Stops the output.
   */
  public void stop() {
    m_Running = false;
  }
}