/**
 * AbstractOptionTraversal.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

/**
 * Interface for code that is being executed while traversing options.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3001 $
 */
public interface OptionTraverser {

  /**
   * Handles the encountered boolean option.
   *
   * @param option	the option to handle
   */
  public void handleBooleanOption(BooleanOption option);

  /**
   * Handles the encountered class option. Precedence over argument option.
   *
   * @param option	the option to handle
   */
  public void handleClassOption(ClassOption option);

  /**
   * Handles the encountered argument option.
   *
   * @param option	the option to handle
   */
  public void handleArgumentOption(AbstractArgumentOption option);

  /**
   * Returns whether the traverser can recurse the specified class
   * (base class from a ClassOption).
   *
   * @param cls		the class to determine for whether recursing is
   * 			possible or not
   * @return		true if to traverse the options recursively
   */
  public boolean canRecurse(Class cls);
}
