/**
 * DataContainer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.data.container;

import java.io.Serializable;

import adams.core.CloneHandler;

/**
 * Generic Interface for data points.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3810 $
 */
public interface DataPoint
  extends Serializable, Comparable, CloneHandler {

  /**
   * Sets the container this point belongs to.
   *
   * @param value	the container
   */
  public void setParent(DataContainer value);

  /**
   * Returns the container this point belongs to.
   *
   * @return		the container, can be null
   */
  public DataContainer getParent();

  /**
   * Returns whether the point belongs to a container.
   *
   * @return		true if the point belongs to a container
   */
  public boolean hasParent();

  /**
   * Returns a clone of itself.
   *
   * @return		the clone
   */
  public Object getClone();

  /**
   * Obtains the stored variables from the other data point.
   *
   * @param other	the data point to get the values from
   */
  public void assign(DataPoint other);
}
