/*
 * InformativeStatistic.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data.statistics;

import java.util.Enumeration;

/**
 * Interface for statistics classes that can return several statistical
 * values.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 */
public interface InformativeStatistic {

  /**
   * Returns a description for this statistic.
   * 
   * @return		the description
   */
  public String getStatisticDescription();
  
  /**
   * Returns all the names of the available statistical values.
   * 
   * @return		the enumeration of names
   */
  public Enumeration<String> statisticNames();
  
  /**
   * Returns the statistical value for the given statistic name.
   * 
   * @param name	the name of the statistical value
   * @return		the corresponding value
   */
  public double getStatistic(String name);
}
