/**
 * Chapter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.doc.docbook;

/**
 * Represents the "chapter" tag.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2504 $
 */
public class Chapter
  extends AbstractComplexElement {

  /** for serialization. */
  private static final long serialVersionUID = -6197886993371097552L;

  /**
   * Initializes the tag.
   */
  public Chapter() {
    super("chapter");
  }

  /**
   * Initializes the tag.
   *
   * @param title	the title of the chapter
   */
  public Chapter(String title) {
    this();
    add(new Title(title));
  }
}
