/**
 * Revisions.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.env;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

import adams.core.Properties;

/**
 * Helper class for determining the revisions of the frameworks used when the
 * software was compiled via "ant".
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2815 $
 */
public class Revisions {

  /** the filename of properties. */
  public final static String FILENAME = "Revisions.props";

  /** the singleton. */
  protected static Revisions m_Singleton;

  /** the properties. */
  protected Properties m_Properties;

  /** the revisions. */
  protected Hashtable<String,String> m_Revisions;

  /**
   * Initializes the revision handling.
   */
  private Revisions() {
    super();

    m_Properties = Environment.getInstance().read(RevisionsDefinition.KEY);
    m_Revisions  = new Hashtable<String,String>();

    // try and retrieve the revision information from the stored files
    Enumeration enm = m_Properties.propertyNames();
    while (enm.hasMoreElements()) {
      String key = (String) enm.nextElement();
      String file = m_Properties.getProperty(key);
      try {
	InputStream in = ClassLoader.getSystemResourceAsStream(file);
	if (in != null) {
	  BufferedReader reader = new BufferedReader(new InputStreamReader(in));
	  String line = reader.readLine();
	  String[] parts = line.split("=");
	  if (parts.length == 2)
	    m_Revisions.put(parts[0], parts[1]);
	  reader.close();
	}
	else {
	  System.err.println("Failed to load revision: " + file);
	}
      }
      catch (Exception e) {
	e.printStackTrace();
      }
    }
  }

  /**
   * Returns an enumeration over the names of all stored versions.
   *
   * @return		the names
   */
  public Enumeration<String> names() {
    return m_Revisions.keys();
  }

  /**
   * Returns the version for the given name.
   *
   * @param name	the identifier to retrieve the version for
   * @return		the version, or null if not found
   */
  public String get(String name) {
    return m_Revisions.get(name);
  }

  /**
   * Returns the singleton instance of the container.
   *
   * @return		the singleton
   */
  public static synchronized Revisions getSingleton() {
    if (m_Singleton == null)
      m_Singleton = new Revisions();

    return m_Singleton;
  }
}
