/**
 * SortableTable.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import javax.swing.table.TableModel;

/**
 * Interface for tables that are sortable.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1403 $
 */
public interface SortableTable {

  /**
   * Sets the base model to use.
   *
   * @param value       the base model
   */
  public void setUnsortedModel(TableModel value);

  /**
   * returns the underlying model, can be null.
   *
   * @return            the current model
   */
  public TableModel getUnsortedModel();

  /**
   * returns whether the table was sorted.
   *
   * @return        true if the table was sorted
   */
  public boolean isSorted();

  /**
   * Returns the sort column.
   *
   * @return		the sort column
   */
  public int getSortColumn();

  /**
   * Returns whether sorting is ascending or not.
   *
   * @return		true if ascending
   * @see		#isSorted()
   * @see		#getSortColumn()
   */
  public boolean isAscending();

  /**
   * sorts the table over the given column (ascending).
   *
   * @param columnIndex     the column to sort over
   */
  public void sort(int columnIndex);

  /**
   * sorts the table over the given column, either ascending or descending.
   *
   * @param columnIndex     the column to sort over
   * @param ascending       ascending if true, otherwise descending
   */
  public void sort(int columnIndex, boolean ascending);
}
