/**
 * FlowEditorDialog.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.flow;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;

import adams.gui.core.BaseDialog;

/**
 * Dialog that displays a flow editor panel.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4095 $
 */
public class FlowEditorDialog
  extends BaseDialog {

  /** for serialization. */
  private static final long serialVersionUID = 545478782839955844L;

  /** the underlying Flow panel. */
  protected FlowEditorPanel m_FlowEditorPanel;

  /**
   * Creates a modal dialog with the specified Dialog as
   * its owner.
   *
   * @param owner	the owning dialog
   */
  public FlowEditorDialog(Dialog owner) {
    super(owner, ModalityType.DOCUMENT_MODAL);
  }

  /**
   * Creates a modal dialog with the specified Frame as
   * its owner.
   *
   * @param owner	the owning frame
   */
  public FlowEditorDialog(Frame owner) {
    super(owner, true);
  }

  /**
   * For initializing the GUI.
   */
  protected void initGUI() {
    String	classname;

    super.initGUI();

    setTitle("Flow editor");

    m_FlowEditorPanel = new FlowEditorPanel();
    classname = FlowEditorPanel.getProperties().getString(
	"FlowEditorClass", FlowEditorPanel.class.getName());
    try {
      m_FlowEditorPanel = (FlowEditorPanel) Class.forName(classname).newInstance();
    }
    catch (Exception ex) {
      m_FlowEditorPanel = new FlowEditorPanel();
    }
    setTitle("Flow editor");
    getContentPane().setLayout(new BorderLayout());
    getContentPane().add(m_FlowEditorPanel, BorderLayout.CENTER);
    setJMenuBar(m_FlowEditorPanel.getMenuBar());
    setSize(800, 600);
    setLocationRelativeTo(this);
  }

  /**
   * Returns the underlying flow editor panel.
   *
   * @return		the panel
   */
  public FlowEditorPanel getFlowEditorPanel() {
    return m_FlowEditorPanel;
  }
}
