/**
 * AbstractFlowEditorTab.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.flow.tab;

import adams.core.ClassLister;
import adams.core.option.OptionUtils;
import adams.gui.core.BasePanel;

/**
 * Ancestor for tabs that show up in the flow editor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3908 $
 */
public abstract class AbstractEditorTab
  extends BasePanel
  implements Comparable<AbstractEditorTab> {

  /** for serialization. */
  private static final long serialVersionUID = -1380932223368136260L;

  /**
   * Returns the title of the tab.
   *
   * @return		the title
   */
  public abstract String getTitle();

  /**
   * Compares this object with the specified object for order.  Returns a
   * negative integer, zero, or a positive integer as this object is less
   * than, equal to, or greater than the specified object.
   * <p/>
   * Simply uses the title for comparison.
   *
   * @param   o the object to be compared.
   * @return  a negative integer, zero, or a positive integer as this object
   *		is less than, equal to, or greater than the specified object.
   *
   * @throws ClassCastException if the specified object's type prevents it
   *         from being compared to this object.
   */
  public int compareTo(AbstractEditorTab o) {
    return getTitle().compareTo(o.getTitle());
  }

  /**
   * Returns whether the two objects are the same.
   * <p/>
   * Only compares the title of the two objects.
   *
   * @param o	the object to be compared
   * @return	true if the object is the same as this one
   */
  public boolean equals(Object o) {
    if (o instanceof AbstractEditorTab)
      return (compareTo((AbstractEditorTab) o) == 0);
    else
      return false;
  }

  /**
   * Returns a list with classnames of tabs.
   *
   * @return		the tab classnames
   */
  public static String[] getTabs() {
    return ClassLister.getSingleton().getClassnames(AbstractEditorTab.class);
  }

  /**
   * Instantiates the tab with the given options.
   *
   * @param classname	the classname of the tab to instantiate
   * @return		the instantiated tab or null if an error occurred
   */
  public static AbstractEditorTab forName(String classname) {
    AbstractEditorTab	result;

    try {
      result = (AbstractEditorTab) OptionUtils.forName(AbstractEditorTab.class, classname, new String[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
      result = null;
    }

    return result;
  }
}
