/*
 * AbstractContainerDisplayStringGenerator.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import java.io.Serializable;

/**
 * Abstract class for generating display IDs.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 952 $
 * @param <T> the type of container to use
 */
public abstract class AbstractContainerDisplayStringGenerator<T extends Container>
  implements Serializable {

  /** for serialization. */
  private static final long serialVersionUID = 3359135975733339153L;

  /**
   * Returns the display String for the container.
   *
   * @param c		the container to get the display string for
   * @return		the string
   */
  public abstract String getDisplay(T c);
}